"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def update(
    hub,
    ctx,
    instance_id: str,
    routing_profile_id: str,
    name: str = None,
    description: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Updates the name and description of a routing profile. The request accepts the following data in JSON format. At least Name or Description must be provided.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        routing_profile_id(str): The identifier of the routing profile.
        name(str, optional): The name of the routing profile. Must not be more than 127 characters. Defaults to None.
        description(str, optional): The description of the routing profile. Must not be more than 250 characters. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.routing_profile.name.update(
                ctx, instance_id=value, routing_profile_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.routing_profile.name.update instance_id=value, routing_profile_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="update_routing_profile_name",
        op_kwargs={
            "InstanceId": instance_id,
            "RoutingProfileId": routing_profile_id,
            "Name": name,
            "Description": description,
        },
    )
