"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    instance_id: str,
    name: str,
    description: str,
    default_outbound_queue_id: str,
    media_concurrencies: List,
    queue_configs: List = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new routing profile.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        name(str): The name of the routing profile. Must not be more than 127 characters.
        description(str): Description of the routing profile. Must not be more than 250 characters.
        default_outbound_queue_id(str): The default outbound queue for the routing profile.
        queue_configs(List, optional): The inbound queues associated with the routing profile. If no queue is added, the agent can make only outbound calls. Defaults to None.
        media_concurrencies(List): The channels that agents can handle in the Contact Control Panel (CCP) for this routing profile.
        tags(Dict, optional): One or more tags. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.routing_profile.init.create(
                ctx,
                instance_id=value,
                name=value,
                description=value,
                default_outbound_queue_id=value,
                media_concurrencies=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.routing_profile.init.create instance_id=value, name=value, description=value, default_outbound_queue_id=value, media_concurrencies=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="create_routing_profile",
        op_kwargs={
            "InstanceId": instance_id,
            "Name": name,
            "Description": description,
            "DefaultOutboundQueueId": default_outbound_queue_id,
            "QueueConfigs": queue_configs,
            "MediaConcurrencies": media_concurrencies,
            "Tags": tags,
        },
    )


async def describe(hub, ctx, instance_id: str, routing_profile_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the specified routing profile.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        routing_profile_id(str): The identifier of the routing profile.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.routing_profile.init.describe(
                ctx, instance_id=value, routing_profile_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.routing_profile.init.describe instance_id=value, routing_profile_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="describe_routing_profile",
        op_kwargs={"InstanceId": instance_id, "RoutingProfileId": routing_profile_id},
    )


async def list_all(
    hub, ctx, instance_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Provides summary information about the routing profiles for the specified Amazon Connect instance. For more information about routing profiles, see Routing Profiles and Create a Routing Profile in the Amazon Connect Administrator Guide.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        next_token(str, optional): The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return per page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.routing_profile.init.list_all(ctx, instance_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.routing_profile.init.list_all instance_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="list_routing_profiles",
        op_kwargs={
            "InstanceId": instance_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
