"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import List


async def update(
    hub, ctx, instance_id: str, routing_profile_id: str, media_concurrencies: List
) -> None:
    r"""
    **Autogenerated function**

    Updates the channels that agents can handle in the Contact Control Panel (CCP) for a routing profile.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        routing_profile_id(str): The identifier of the routing profile.
        media_concurrencies(List): The channels that agents can handle in the Contact Control Panel (CCP).
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.routing_profile.concurrency.update(
                ctx, instance_id=value, routing_profile_id=value, media_concurrencies=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.routing_profile.concurrency.update instance_id=value, routing_profile_id=value, media_concurrencies=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="update_routing_profile_concurrency",
        op_kwargs={
            "InstanceId": instance_id,
            "RoutingProfileId": routing_profile_id,
            "MediaConcurrencies": media_concurrencies,
        },
    )
