"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def update(
    hub,
    ctx,
    instance_id: str,
    quick_connect_id: str,
    name: str = None,
    description: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Updates the name and description of a quick connect. The request accepts the following data in JSON format. At least Name or Description must be provided.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        quick_connect_id(str): The identifier for the quick connect.
        name(str, optional): The name of the quick connect. Defaults to None.
        description(str, optional): The description of the quick connect. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.quick_connect.name.update(
                ctx, instance_id=value, quick_connect_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.quick_connect.name.update instance_id=value, quick_connect_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="update_quick_connect_name",
        op_kwargs={
            "InstanceId": instance_id,
            "QuickConnectId": quick_connect_id,
            "Name": name,
            "Description": description,
        },
    )
