"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    instance_id: str,
    name: str,
    quick_connect_config: Dict,
    description: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a quick connect for the specified Amazon Connect instance.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        name(str): The name of the quick connect.
        description(str, optional): The description of the quick connect. Defaults to None.
        quick_connect_config(Dict): Configuration settings for the quick connect.
        tags(Dict, optional): One or more tags. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.quick_connect.init.create(
                ctx, instance_id=value, name=value, quick_connect_config=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.quick_connect.init.create instance_id=value, name=value, quick_connect_config=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="create_quick_connect",
        op_kwargs={
            "InstanceId": instance_id,
            "Name": name,
            "Description": description,
            "QuickConnectConfig": quick_connect_config,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, instance_id: str, quick_connect_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a quick connect.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        quick_connect_id(str): The identifier for the quick connect.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.quick_connect.init.delete(
                ctx, instance_id=value, quick_connect_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.quick_connect.init.delete instance_id=value, quick_connect_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="delete_quick_connect",
        op_kwargs={"InstanceId": instance_id, "QuickConnectId": quick_connect_id},
    )


async def describe(hub, ctx, instance_id: str, quick_connect_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the quick connect.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        quick_connect_id(str): The identifier for the quick connect.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.quick_connect.init.describe(
                ctx, instance_id=value, quick_connect_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.quick_connect.init.describe instance_id=value, quick_connect_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="describe_quick_connect",
        op_kwargs={"InstanceId": instance_id, "QuickConnectId": quick_connect_id},
    )


async def list_all(
    hub,
    ctx,
    instance_id: str,
    next_token: str = None,
    max_results: int = None,
    quick_connect_types: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Provides information about the quick connects for the specified Amazon Connect instance.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        next_token(str, optional): The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return per page. Defaults to None.
        quick_connect_types(List, optional): The type of quick connect. In the Amazon Connect console, when you create a quick connect, you are prompted to assign one of the following types: Agent (USER), External (PHONE_NUMBER), or Queue (QUEUE). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.quick_connect.init.list_all(ctx, instance_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.quick_connect.init.list_all instance_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="list_quick_connects",
        op_kwargs={
            "InstanceId": instance_id,
            "NextToken": next_token,
            "MaxResults": max_results,
            "QuickConnectTypes": quick_connect_types,
        },
    )
