"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(
    hub, ctx, instance_id: str, quick_connect_id: str, quick_connect_config: Dict
) -> None:
    r"""
    **Autogenerated function**

    Updates the configuration settings for the specified quick connect.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        quick_connect_id(str): The identifier for the quick connect.
        quick_connect_config(Dict): Information about the configuration settings for the quick connect.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.quick_connect.config.update(
                ctx, instance_id=value, quick_connect_id=value, quick_connect_config=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.quick_connect.config.update instance_id=value, quick_connect_id=value, quick_connect_config=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="update_quick_connect_config",
        op_kwargs={
            "InstanceId": instance_id,
            "QuickConnectId": quick_connect_id,
            "QuickConnectConfig": quick_connect_config,
        },
    )
