"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def associate(
    hub, ctx, instance_id: str, queue_id: str, quick_connect_ids: List
) -> None:
    r"""
    **Autogenerated function**

    This API is in preview release for Amazon Connect and is subject to change. Associates a set of quick connects with a queue.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        queue_id(str): The identifier for the queue.
        quick_connect_ids(List): The quick connects to associate with this queue.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.queue.quick_connect.associate(
                ctx, instance_id=value, queue_id=value, quick_connect_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.queue.quick_connect.associate instance_id=value, queue_id=value, quick_connect_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="associate_queue_quick_connects",
        op_kwargs={
            "InstanceId": instance_id,
            "QueueId": queue_id,
            "QuickConnectIds": quick_connect_ids,
        },
    )


async def disassociate(
    hub, ctx, instance_id: str, queue_id: str, quick_connect_ids: List
) -> None:
    r"""
    **Autogenerated function**

    This API is in preview release for Amazon Connect and is subject to change. Disassociates a set of quick connects from a queue.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        queue_id(str): The identifier for the queue.
        quick_connect_ids(List): The quick connects to disassociate from the queue.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.queue.quick_connect.disassociate(
                ctx, instance_id=value, queue_id=value, quick_connect_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.queue.quick_connect.disassociate instance_id=value, queue_id=value, quick_connect_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="disassociate_queue_quick_connects",
        op_kwargs={
            "InstanceId": instance_id,
            "QueueId": queue_id,
            "QuickConnectIds": quick_connect_ids,
        },
    )


async def list_all(
    hub,
    ctx,
    instance_id: str,
    queue_id: str,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    This API is in preview release for Amazon Connect and is subject to change. Lists the quick connects associated with a queue.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        queue_id(str): The identifier for the queue.
        next_token(str, optional): The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return per page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.queue.quick_connect.list_all(
                ctx, instance_id=value, queue_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.queue.quick_connect.list_all instance_id=value, queue_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="list_queue_quick_connects",
        op_kwargs={
            "InstanceId": instance_id,
            "QueueId": queue_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
