"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(
    hub, ctx, instance_id: str, queue_id: str, outbound_caller_config: Dict
) -> None:
    r"""
    **Autogenerated function**

    This API is in preview release for Amazon Connect and is subject to change. Updates the outbound caller ID name, number, and outbound whisper flow for a specified queue.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        queue_id(str): The identifier for the queue.
        outbound_caller_config(Dict): The outbound caller ID name, number, and outbound whisper flow.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.queue.outbound_caller_config.update(
                ctx, instance_id=value, queue_id=value, outbound_caller_config=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.queue.outbound_caller_config.update instance_id=value, queue_id=value, outbound_caller_config=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="update_queue_outbound_caller_config",
        op_kwargs={
            "InstanceId": instance_id,
            "QueueId": queue_id,
            "OutboundCallerConfig": outbound_caller_config,
        },
    )
