"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def update(
    hub, ctx, instance_id: str, queue_id: str, name: str = None, description: str = None
) -> None:
    r"""
    **Autogenerated function**

    This API is in preview release for Amazon Connect and is subject to change. Updates the name and description of a queue. At least Name or Description must be provided.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        queue_id(str): The identifier for the queue.
        name(str, optional): The name of the queue. Defaults to None.
        description(str, optional): The description of the queue. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.queue.name.update(
                ctx, instance_id=value, queue_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.queue.name.update instance_id=value, queue_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="update_queue_name",
        op_kwargs={
            "InstanceId": instance_id,
            "QueueId": queue_id,
            "Name": name,
            "Description": description,
        },
    )
