"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def update_multiple(
    hub, ctx, instance_id: str, queue_id: str, max_contacts: int = None
) -> None:
    r"""
    **Autogenerated function**

    This API is in preview release for Amazon Connect and is subject to change. Updates the maximum number of contacts allowed in a queue before it is considered full.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        queue_id(str): The identifier for the queue.
        max_contacts(int, optional): The maximum number of contacts that can be in the queue before it is considered full. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.queue.max_contact.update_multiple(
                ctx, instance_id=value, queue_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.queue.max_contact.update_multiple instance_id=value, queue_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="update_queue_max_contacts",
        op_kwargs={
            "InstanceId": instance_id,
            "QueueId": queue_id,
            "MaxContacts": max_contacts,
        },
    )
