"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    instance_id: str,
    name: str,
    hours_of_operation_id: str,
    description: str = None,
    outbound_caller_config: Dict = None,
    max_contacts: int = None,
    quick_connect_ids: List = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    This API is in preview release for Amazon Connect and is subject to change. Creates a new queue for the specified Amazon Connect instance.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        name(str): The name of the queue.
        description(str, optional): The description of the queue. Defaults to None.
        outbound_caller_config(Dict, optional): The outbound caller ID name, number, and outbound whisper flow. Defaults to None.
        hours_of_operation_id(str): The identifier for the hours of operation.
        max_contacts(int, optional): The maximum number of contacts that can be in the queue before it is considered full. Defaults to None.
        quick_connect_ids(List, optional): The quick connects available to agents who are working the queue. Defaults to None.
        tags(Dict, optional): One or more tags. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.queue.init.create(
                ctx, instance_id=value, name=value, hours_of_operation_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.queue.init.create instance_id=value, name=value, hours_of_operation_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="create_queue",
        op_kwargs={
            "InstanceId": instance_id,
            "Name": name,
            "Description": description,
            "OutboundCallerConfig": outbound_caller_config,
            "HoursOfOperationId": hours_of_operation_id,
            "MaxContacts": max_contacts,
            "QuickConnectIds": quick_connect_ids,
            "Tags": tags,
        },
    )


async def describe(hub, ctx, instance_id: str, queue_id: str) -> Dict:
    r"""
    **Autogenerated function**

    This API is in preview release for Amazon Connect and is subject to change. Describes the specified queue.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        queue_id(str): The identifier for the queue.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.queue.init.describe(
                ctx, instance_id=value, queue_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.queue.init.describe instance_id=value, queue_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="describe_queue",
        op_kwargs={"InstanceId": instance_id, "QueueId": queue_id},
    )


async def list_all(
    hub,
    ctx,
    instance_id: str,
    queue_types: List = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Provides information about the queues for the specified Amazon Connect instance. If you do not specify a QueueTypes parameter, both standard and agent queues are returned. This might cause an unexpected truncation of results if you have more than 1000 agents and you limit the number of results of the API call in code. For more information about queues, see Queues: Standard and Agent in the Amazon Connect Administrator Guide.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        queue_types(List, optional): The type of queue. Defaults to None.
        next_token(str, optional): The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return per page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.queue.init.list_all(ctx, instance_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.queue.init.list_all instance_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="list_queues",
        op_kwargs={
            "InstanceId": instance_id,
            "QueueTypes": queue_types,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
