"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def update(
    hub, ctx, instance_id: str, queue_id: str, hours_of_operation_id: str
) -> None:
    r"""
    **Autogenerated function**

    This API is in preview release for Amazon Connect and is subject to change. Updates the hours of operation for the specified queue.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        queue_id(str): The identifier for the queue.
        hours_of_operation_id(str): The identifier for the hours of operation.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.queue.hour_of_operation.update(
                ctx, instance_id=value, queue_id=value, hours_of_operation_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.queue.hour_of_operation.update instance_id=value, queue_id=value, hours_of_operation_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="update_queue_hours_of_operation",
        op_kwargs={
            "InstanceId": instance_id,
            "QueueId": queue_id,
            "HoursOfOperationId": hours_of_operation_id,
        },
    )
