"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(hub, ctx, instance_id: str, function_arn: str) -> None:
    r"""
    **Autogenerated function**

    This API is in preview release for Amazon Connect and is subject to change. Allows the specified Amazon Connect instance to access the specified Lambda function.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        function_arn(str): The Amazon Resource Name (ARN) for the Lambda function being associated. Maximum number of characters allowed is 140.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.lambda_function.associate(
                ctx, instance_id=value, function_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.lambda_function.associate instance_id=value, function_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="associate_lambda_function",
        op_kwargs={"InstanceId": instance_id, "FunctionArn": function_arn},
    )


async def disassociate(hub, ctx, instance_id: str, function_arn: str) -> None:
    r"""
    **Autogenerated function**

    This API is in preview release for Amazon Connect and is subject to change. Remove the Lambda function from the dropdown options available in the relevant contact flow blocks.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance..
        function_arn(str): The Amazon Resource Name (ARN) of the Lambda function being disassociated.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.lambda_function.disassociate(
                ctx, instance_id=value, function_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.lambda_function.disassociate instance_id=value, function_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="disassociate_lambda_function",
        op_kwargs={"InstanceId": instance_id, "FunctionArn": function_arn},
    )


async def list_all(
    hub, ctx, instance_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    This API is in preview release for Amazon Connect and is subject to change. Returns a paginated list of all Lambda functions that display in the dropdown options in the relevant contact flow blocks.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        next_token(str, optional): The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return per page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.lambda_function.list_all(ctx, instance_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.lambda_function.list_all instance_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="list_lambda_functions",
        op_kwargs={
            "InstanceId": instance_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
