"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    instance_id: str,
    integration_type: str,
    integration_arn: str,
    source_application_url: str,
    source_application_name: str,
    source_type: str,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Create an AppIntegration association with an Amazon Connect instance.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        integration_type(str): The type of information to be ingested.
        integration_arn(str): The Amazon Resource Name (ARN) of the integration.
        source_application_url(str): The URL for the external application.
        source_application_name(str): The name of the external application.
        source_type(str): The type of the data source.
        tags(Dict, optional): One or more tags. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.integration_association.create(
                ctx,
                instance_id=value,
                integration_type=value,
                integration_arn=value,
                source_application_url=value,
                source_application_name=value,
                source_type=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.integration_association.create instance_id=value, integration_type=value, integration_arn=value, source_application_url=value, source_application_name=value, source_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="create_integration_association",
        op_kwargs={
            "InstanceId": instance_id,
            "IntegrationType": integration_type,
            "IntegrationArn": integration_arn,
            "SourceApplicationUrl": source_application_url,
            "SourceApplicationName": source_application_name,
            "SourceType": source_type,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, instance_id: str, integration_association_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes an AppIntegration association from an Amazon Connect instance. The association must not have any use cases associated with it.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        integration_association_id(str): The identifier for the AppIntegration association.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.integration_association.delete(
                ctx, instance_id=value, integration_association_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.integration_association.delete instance_id=value, integration_association_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="delete_integration_association",
        op_kwargs={
            "InstanceId": instance_id,
            "IntegrationAssociationId": integration_association_id,
        },
    )


async def list_all(
    hub, ctx, instance_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Provides summary information about the AppIntegration associations for the specified Amazon Connect instance.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        next_token(str, optional): The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return per page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.integration_association.list_all(ctx, instance_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.integration_association.list_all instance_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="list_integration_associations",
        op_kwargs={
            "InstanceId": instance_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
