"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(
    hub, ctx, instance_id: str, resource_type: str, storage_config: Dict
) -> Dict:
    r"""
    **Autogenerated function**

    This API is in preview release for Amazon Connect and is subject to change. Associates a storage resource type for the first time. You can only associate one type of storage configuration in a single call. This means, for example, that you can't define an instance with multiple S3 buckets for storing chat transcripts. This API does not create a resource that doesn't exist. It only associates it to the instance. Ensure that the resource being specified in the storage configuration, like an S3 bucket, exists when being used for association.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        resource_type(str): A valid resource type.
        storage_config(Dict): A valid storage type.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.instance.storage_config.associate(
                ctx, instance_id=value, resource_type=value, storage_config=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.instance.storage_config.associate instance_id=value, resource_type=value, storage_config=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="associate_instance_storage_config",
        op_kwargs={
            "InstanceId": instance_id,
            "ResourceType": resource_type,
            "StorageConfig": storage_config,
        },
    )


async def describe(
    hub, ctx, instance_id: str, association_id: str, resource_type: str
) -> Dict:
    r"""
    **Autogenerated function**

    This API is in preview release for Amazon Connect and is subject to change. Retrieves the current storage configurations for the specified resource type, association ID, and instance ID.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        association_id(str): The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.
        resource_type(str): A valid resource type.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.instance.storage_config.describe(
                ctx, instance_id=value, association_id=value, resource_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.instance.storage_config.describe instance_id=value, association_id=value, resource_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="describe_instance_storage_config",
        op_kwargs={
            "InstanceId": instance_id,
            "AssociationId": association_id,
            "ResourceType": resource_type,
        },
    )


async def disassociate(
    hub, ctx, instance_id: str, association_id: str, resource_type: str
) -> None:
    r"""
    **Autogenerated function**

    This API is in preview release for Amazon Connect and is subject to change. Removes the storage type configurations for the specified resource type and association ID.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        association_id(str): The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.
        resource_type(str): A valid resource type.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.instance.storage_config.disassociate(
                ctx, instance_id=value, association_id=value, resource_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.instance.storage_config.disassociate instance_id=value, association_id=value, resource_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="disassociate_instance_storage_config",
        op_kwargs={
            "InstanceId": instance_id,
            "AssociationId": association_id,
            "ResourceType": resource_type,
        },
    )


async def list_all(
    hub,
    ctx,
    instance_id: str,
    resource_type: str,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    This API is in preview release for Amazon Connect and is subject to change. Returns a paginated list of storage configs for the identified instance and resource type.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        resource_type(str): A valid resource type.
        next_token(str, optional): The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return per page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.instance.storage_config.list_all(
                ctx, instance_id=value, resource_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.instance.storage_config.list_all instance_id=value, resource_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="list_instance_storage_configs",
        op_kwargs={
            "InstanceId": instance_id,
            "ResourceType": resource_type,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def update(
    hub,
    ctx,
    instance_id: str,
    association_id: str,
    resource_type: str,
    storage_config: Dict,
) -> None:
    r"""
    **Autogenerated function**

    This API is in preview release for Amazon Connect and is subject to change. Updates an existing configuration for a resource type. This API is idempotent.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        association_id(str): The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.
        resource_type(str): A valid resource type.
        storage_config(Dict): The storage configuration for the instance.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.instance.storage_config.update(
                ctx,
                instance_id=value,
                association_id=value,
                resource_type=value,
                storage_config=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.instance.storage_config.update instance_id=value, association_id=value, resource_type=value, storage_config=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="update_instance_storage_config",
        op_kwargs={
            "InstanceId": instance_id,
            "AssociationId": association_id,
            "ResourceType": resource_type,
            "StorageConfig": storage_config,
        },
    )
