"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    identity_management_type: str,
    inbound_calls_enabled: bool,
    outbound_calls_enabled: bool,
    client_token: str = None,
    instance_alias: str = None,
    directory_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    This API is in preview release for Amazon Connect and is subject to change. Initiates an Amazon Connect instance with all the supported channels enabled. It does not attach any storage, such as Amazon Simple Storage Service (Amazon S3) or Amazon Kinesis. It also does not allow for any configurations on features, such as Contact Lens for Amazon Connect.  Amazon Connect enforces a limit on the total number of instances that you can create or delete in 30 days. If you exceed this limit, you will get an error message indicating there has been an excessive number of attempts at creating or deleting instances. You must wait 30 days before you can restart creating and deleting instances in your account.

    Args:
        client_token(str, optional): The idempotency token. Defaults to None.
        identity_management_type(str): The type of identity management for your Amazon Connect users.
        instance_alias(str, optional): The name for your instance. Defaults to None.
        directory_id(str, optional): The identifier for the directory. Defaults to None.
        inbound_calls_enabled(bool): Your contact center handles incoming contacts.
        outbound_calls_enabled(bool): Your contact center allows outbound calls.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.instance.init.create(
                ctx,
                identity_management_type=value,
                inbound_calls_enabled=value,
                outbound_calls_enabled=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.instance.init.create identity_management_type=value, inbound_calls_enabled=value, outbound_calls_enabled=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="create_instance",
        op_kwargs={
            "ClientToken": client_token,
            "IdentityManagementType": identity_management_type,
            "InstanceAlias": instance_alias,
            "DirectoryId": directory_id,
            "InboundCallsEnabled": inbound_calls_enabled,
            "OutboundCallsEnabled": outbound_calls_enabled,
        },
    )


async def delete(hub, ctx, instance_id: str) -> None:
    r"""
    **Autogenerated function**

    This API is in preview release for Amazon Connect and is subject to change. Deletes the Amazon Connect instance. Amazon Connect enforces a limit on the total number of instances that you can create or delete in 30 days. If you exceed this limit, you will get an error message indicating there has been an excessive number of attempts at creating or deleting instances. You must wait 30 days before you can restart creating and deleting instances in your account.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.instance.init.delete(ctx, instance_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.instance.init.delete instance_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="delete_instance",
        op_kwargs={"InstanceId": instance_id},
    )


async def describe(hub, ctx, instance_id: str) -> Dict:
    r"""
    **Autogenerated function**

    This API is in preview release for Amazon Connect and is subject to change. Returns the current state of the specified instance identifier. It tracks the instance while it is being created and returns an error status, if applicable.  If an instance is not created successfully, the instance status reason field returns details relevant to the reason. The instance in a failed state is returned only for 24 hours after the CreateInstance API was invoked.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.instance.init.describe(ctx, instance_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.instance.init.describe instance_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="describe_instance",
        op_kwargs={"InstanceId": instance_id},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    This API is in preview release for Amazon Connect and is subject to change. Return a list of instances which are in active state, creation-in-progress state, and failed state. Instances that aren't successfully created (they are in a failed state) are returned only for 24 hours after the CreateInstance API was invoked.

    Args:
        next_token(str, optional): The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return per page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.instance.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.instance.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="list_instances",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )
