"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, instance_id: str, attribute_type: str) -> Dict:
    r"""
    **Autogenerated function**

    This API is in preview release for Amazon Connect and is subject to change. Describes the specified instance attribute.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        attribute_type(str): The type of attribute.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.instance.attribute.describe(
                ctx, instance_id=value, attribute_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.instance.attribute.describe instance_id=value, attribute_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="describe_instance_attribute",
        op_kwargs={"InstanceId": instance_id, "AttributeType": attribute_type},
    )


async def list_all(
    hub, ctx, instance_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    This API is in preview release for Amazon Connect and is subject to change. Returns a paginated list of all attribute types for the given instance.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        next_token(str, optional): The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return per page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.instance.attribute.list_all(ctx, instance_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.instance.attribute.list_all instance_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="list_instance_attributes",
        op_kwargs={
            "InstanceId": instance_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def update(hub, ctx, instance_id: str, attribute_type: str, value: str) -> None:
    r"""
    **Autogenerated function**

    This API is in preview release for Amazon Connect and is subject to change. Updates the value for the specified attribute type.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        attribute_type(str): The type of attribute.
        value(str): The value for the attribute. Maximum character limit is 100. .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.instance.attribute.update(
                ctx, instance_id=value, attribute_type=value, value=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.instance.attribute.update instance_id=value, attribute_type=value, value=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="update_instance_attribute",
        op_kwargs={
            "InstanceId": instance_id,
            "AttributeType": attribute_type,
            "Value": value,
        },
    )
