"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def resume(
    hub, ctx, instance_id: str, contact_id: str, initial_contact_id: str
) -> Dict:
    r"""
    **Autogenerated function**

    When a contact is being recorded, and the recording has been suspended using SuspendContactRecording, this API resumes recording the call. Only voice recordings are supported at this time.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        contact_id(str): The identifier of the contact.
        initial_contact_id(str): The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.contact.recording.resume(
                ctx, instance_id=value, contact_id=value, initial_contact_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.contact.recording.resume instance_id=value, contact_id=value, initial_contact_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="resume_contact_recording",
        op_kwargs={
            "InstanceId": instance_id,
            "ContactId": contact_id,
            "InitialContactId": initial_contact_id,
        },
    )


async def start(
    hub,
    ctx,
    instance_id: str,
    contact_id: str,
    initial_contact_id: str,
    voice_recording_configuration: Dict,
) -> Dict:
    r"""
    **Autogenerated function**

    Starts recording the contact when the agent joins the call. StartContactRecording is a one-time action. For example, if you use StopContactRecording to stop recording an ongoing call, you can't use StartContactRecording to restart it. For scenarios where the recording has started and you want to suspend and resume it, such as when collecting sensitive information (for example, a credit card number), use SuspendContactRecording and ResumeContactRecording. You can use this API to override the recording behavior configured in the Set recording behavior block. Only voice recordings are supported at this time.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        contact_id(str): The identifier of the contact.
        initial_contact_id(str): The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.
        voice_recording_configuration(Dict): The person being recorded.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.contact.recording.start(
                ctx,
                instance_id=value,
                contact_id=value,
                initial_contact_id=value,
                voice_recording_configuration=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.contact.recording.start instance_id=value, contact_id=value, initial_contact_id=value, voice_recording_configuration=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="start_contact_recording",
        op_kwargs={
            "InstanceId": instance_id,
            "ContactId": contact_id,
            "InitialContactId": initial_contact_id,
            "VoiceRecordingConfiguration": voice_recording_configuration,
        },
    )


async def stop(
    hub, ctx, instance_id: str, contact_id: str, initial_contact_id: str
) -> Dict:
    r"""
    **Autogenerated function**

    Stops recording a call when a contact is being recorded. StopContactRecording is a one-time action. If you use StopContactRecording to stop recording an ongoing call, you can't use StartContactRecording to restart it. For scenarios where the recording has started and you want to suspend it for sensitive information (for example, to collect a credit card number), and then restart it, use SuspendContactRecording and ResumeContactRecording. Only voice recordings are supported at this time.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        contact_id(str): The identifier of the contact.
        initial_contact_id(str): The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.contact.recording.stop(
                ctx, instance_id=value, contact_id=value, initial_contact_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.contact.recording.stop instance_id=value, contact_id=value, initial_contact_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="stop_contact_recording",
        op_kwargs={
            "InstanceId": instance_id,
            "ContactId": contact_id,
            "InitialContactId": initial_contact_id,
        },
    )


async def suspend(
    hub, ctx, instance_id: str, contact_id: str, initial_contact_id: str
) -> Dict:
    r"""
    **Autogenerated function**

    When a contact is being recorded, this API suspends recording the call. For example, you might suspend the call recording while collecting sensitive information, such as a credit card number. Then use ResumeContactRecording to restart recording.  The period of time that the recording is suspended is filled with silence in the final recording.  Only voice recordings are supported at this time.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        contact_id(str): The identifier of the contact.
        initial_contact_id(str): The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.contact.recording.suspend(
                ctx, instance_id=value, contact_id=value, initial_contact_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.contact.recording.suspend instance_id=value, contact_id=value, initial_contact_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="suspend_contact_recording",
        op_kwargs={
            "InstanceId": instance_id,
            "ContactId": contact_id,
            "InitialContactId": initial_contact_id,
        },
    )
