"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def stop(hub, ctx, contact_id: str, instance_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Ends the specified contact.

    Args:
        contact_id(str): The ID of the contact.
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.contact.init.stop(
                ctx, contact_id=value, instance_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.contact.init.stop contact_id=value, instance_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="stop_contact",
        op_kwargs={"ContactId": contact_id, "InstanceId": instance_id},
    )
