"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def update(
    hub,
    ctx,
    instance_id: str,
    contact_flow_id: str,
    name: str = None,
    description: str = None,
) -> None:
    r"""
    **Autogenerated function**

    The name of the contact flow. You can also create and update contact flows using the Amazon Connect Flow language.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance.
        contact_flow_id(str): The identifier of the contact flow.
        name(str, optional): The name of the contact flow. Defaults to None.
        description(str, optional): The description of the contact flow. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.contact.flow.name.update(
                ctx, instance_id=value, contact_flow_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.contact.flow.name.update instance_id=value, contact_flow_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="update_contact_flow_name",
        op_kwargs={
            "InstanceId": instance_id,
            "ContactFlowId": contact_flow_id,
            "Name": name,
            "Description": description,
        },
    )
