"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    instance_id: str,
    name: str,
    type_: str,
    content: str,
    description: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a contact flow for the specified Amazon Connect instance. You can also create and update contact flows using the Amazon Connect Flow language.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance.
        name(str): The name of the contact flow.
        type_(str): The type of the contact flow. For descriptions of the available types, see Choose a Contact Flow Type in the Amazon Connect Administrator Guide.
        description(str, optional): The description of the contact flow. . Defaults to None.
        content(str): The content of the contact flow. .
        tags(Dict, optional): One or more tags. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.contact.flow.init.create(
                ctx, instance_id=value, name=value, type_=value, content=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.contact.flow.init.create instance_id=value, name=value, type_=value, content=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="create_contact_flow",
        op_kwargs={
            "InstanceId": instance_id,
            "Name": name,
            "Type": type_,
            "Description": description,
            "Content": content,
            "Tags": tags,
        },
    )


async def describe(hub, ctx, instance_id: str, contact_flow_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the specified contact flow. You can also create and update contact flows using the Amazon Connect Flow language.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance.
        contact_flow_id(str): The identifier of the contact flow.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.contact.flow.init.describe(
                ctx, instance_id=value, contact_flow_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.contact.flow.init.describe instance_id=value, contact_flow_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="describe_contact_flow",
        op_kwargs={"InstanceId": instance_id, "ContactFlowId": contact_flow_id},
    )


async def list_all(
    hub,
    ctx,
    instance_id: str,
    contact_flow_types: List = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Provides information about the contact flows for the specified Amazon Connect instance. You can also create and update contact flows using the Amazon Connect Flow language. For more information about contact flows, see Contact Flows in the Amazon Connect Administrator Guide.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        contact_flow_types(List, optional): The type of contact flow. Defaults to None.
        next_token(str, optional): The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return per page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.contact.flow.init.list_all(ctx, instance_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.contact.flow.init.list_all instance_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="list_contact_flows",
        op_kwargs={
            "InstanceId": instance_id,
            "ContactFlowTypes": contact_flow_types,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
