"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def update(
    hub, ctx, instance_id: str, contact_flow_id: str, content: str
) -> None:
    r"""
    **Autogenerated function**

    Updates the specified contact flow. You can also create and update contact flows using the Amazon Connect Flow language.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance.
        contact_flow_id(str): The identifier of the contact flow.
        content(str): The JSON string that represents contact flow’s content. For an example, see Example contact flow in Amazon Connect Flow language in the Amazon Connect Administrator Guide. .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.contact.flow.content.update(
                ctx, instance_id=value, contact_flow_id=value, content=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.contact.flow.content.update instance_id=value, contact_flow_id=value, content=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="update_contact_flow_content",
        op_kwargs={
            "InstanceId": instance_id,
            "ContactFlowId": contact_flow_id,
            "Content": content,
        },
    )
