"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(hub, ctx, instance_id: str, initial_contact_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the contact attributes for the specified contact.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance.
        initial_contact_id(str): The identifier of the initial contact.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.contact.attribute.get_all(
                ctx, instance_id=value, initial_contact_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.contact.attribute.get_all instance_id=value, initial_contact_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="get_contact_attributes",
        op_kwargs={"InstanceId": instance_id, "InitialContactId": initial_contact_id},
    )


async def update_multiple(
    hub, ctx, initial_contact_id: str, instance_id: str, attributes: Dict
) -> Dict:
    r"""
    **Autogenerated function**

    Creates or updates user-defined contact attributes associated with the specified contact. You can create or update user-defined attributes for both ongoing and completed contacts. For example, while the call is active, you can update the customer's name or the reason the customer called. You can add notes about steps that the agent took during the call that display to the next agent that takes the call. You can also update attributes for a contact using data from your CRM application and save the data with the contact in Amazon Connect. You could also flag calls for additional analysis, such as legal review or to identify abusive callers. Contact attributes are available in Amazon Connect for 24 months, and are then deleted. For information about CTR retention and the maximum size of the CTR attributes section, see Feature specifications in the Amazon Connect Administrator Guide.   Important: You cannot use the operation to update attributes for contacts that occurred prior to the release of the API, which was September 12, 2018. You can update attributes only for contacts that started after the release of the API. If you attempt to update attributes for a contact that occurred prior to the release of the API, a 400 error is returned. This applies also to queued callbacks that were initiated prior to the release of the API but are still active in your instance.

    Args:
        initial_contact_id(str): The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        attributes(Dict): The Amazon Connect attributes. These attributes can be accessed in contact flows just like any other contact attributes. You can have up to 32,768 UTF-8 bytes across all attributes for a contact. Attribute keys can include only alphanumeric, dash, and underscore characters.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.contact.attribute.update_multiple(
                ctx, initial_contact_id=value, instance_id=value, attributes=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.contact.attribute.update_multiple initial_contact_id=value, instance_id=value, attributes=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="update_contact_attributes",
        op_kwargs={
            "InitialContactId": initial_contact_id,
            "InstanceId": instance_id,
            "Attributes": attributes,
        },
    )
