"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def start(
    hub,
    ctx,
    instance_id: str,
    contact_flow_id: str,
    participant_details: Dict,
    attributes: Dict = None,
    initial_message: Dict = None,
    client_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Initiates a contact flow to start a new chat for the customer. Response of this API provides a token required to obtain credentials from the CreateParticipantConnection API in the Amazon Connect Participant Service. When a new chat contact is successfully created, clients must subscribe to the participant’s connection for the created chat within 5 minutes. This is achieved by invoking CreateParticipantConnection with WEBSOCKET and CONNECTION_CREDENTIALS.  A 429 error occurs in two situations:   API rate limit is exceeded. API TPS throttling returns a TooManyRequests exception.   The quota for concurrent active chats is exceeded. Active chat throttling returns a LimitExceededException.   For more information about chat, see Chat in the Amazon Connect Administrator Guide.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        contact_flow_id(str): The identifier of the contact flow for initiating the chat. To see the ContactFlowId in the Amazon Connect console user interface, on the navigation menu go to Routing, Contact Flows. Choose the contact flow. On the contact flow page, under the name of the contact flow, choose Show additional flow information. The ContactFlowId is the last part of the ARN, shown here in bold:  arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/846ec553-a005-41c0-8341-xxxxxxxxxxxx .
        attributes(Dict, optional): A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes. They can be accessed in contact flows just like any other contact attributes.  There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only alphanumeric, dash, and underscore characters. Defaults to None.
        participant_details(Dict): Information identifying the participant.
        initial_message(Dict, optional): The initial message to be sent to the newly created chat. Defaults to None.
        client_token(str, optional): A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.chat_contact.start(
                ctx, instance_id=value, contact_flow_id=value, participant_details=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.chat_contact.start instance_id=value, contact_flow_id=value, participant_details=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="start_chat_contact",
        op_kwargs={
            "InstanceId": instance_id,
            "ContactFlowId": contact_flow_id,
            "Attributes": attributes,
            "ParticipantDetails": participant_details,
            "InitialMessage": initial_message,
            "ClientToken": client_token,
        },
    )
