"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(
    hub, ctx, instance_id: str, lex_bot: Dict = None, lex_v2_bot: Dict = None
) -> None:
    r"""
    **Autogenerated function**

    This API is in preview release for Amazon Connect and is subject to change. Allows the specified Amazon Connect instance to access the specified Amazon Lex or Amazon Lex V2 bot.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        lex_bot(Dict, optional): Configuration information of an Amazon Lex bot. Defaults to None.
        lex_v2_bot(Dict, optional): The Amazon Lex V2 bot to associate with the instance. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.bot.associate(ctx, instance_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.bot.associate instance_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="associate_bot",
        op_kwargs={
            "InstanceId": instance_id,
            "LexBot": lex_bot,
            "LexV2Bot": lex_v2_bot,
        },
    )


async def disassociate(
    hub, ctx, instance_id: str, lex_bot: Dict = None, lex_v2_bot: Dict = None
) -> None:
    r"""
    **Autogenerated function**

    This API is in preview release for Amazon Connect and is subject to change. Revokes authorization from the specified instance to access the specified Amazon Lex or Amazon Lex V2 bot.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        lex_bot(Dict, optional): Configuration information of an Amazon Lex bot. Defaults to None.
        lex_v2_bot(Dict, optional): The Amazon Lex V2 bot to disassociate from the instance. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.bot.disassociate(ctx, instance_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.bot.disassociate instance_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="disassociate_bot",
        op_kwargs={
            "InstanceId": instance_id,
            "LexBot": lex_bot,
            "LexV2Bot": lex_v2_bot,
        },
    )
