"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(hub, ctx, instance_id: str, origin: str) -> None:
    r"""
    **Autogenerated function**

    This API is in preview release for Amazon Connect and is subject to change. Associates an approved origin to an Amazon Connect instance.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        origin(str): The domain to add to your allow list.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.approved_origin.associate(
                ctx, instance_id=value, origin=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.approved_origin.associate instance_id=value, origin=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="associate_approved_origin",
        op_kwargs={"InstanceId": instance_id, "Origin": origin},
    )


async def disassociate(hub, ctx, instance_id: str, origin: str) -> None:
    r"""
    **Autogenerated function**

    This API is in preview release for Amazon Connect and is subject to change. Revokes access to integrated applications from Amazon Connect.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        origin(str): The domain URL of the integrated application.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.approved_origin.disassociate(
                ctx, instance_id=value, origin=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.approved_origin.disassociate instance_id=value, origin=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="disassociate_approved_origin",
        op_kwargs={"InstanceId": instance_id, "Origin": origin},
    )


async def list_all(
    hub, ctx, instance_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    This API is in preview release for Amazon Connect and is subject to change. Returns a paginated list of all approved origins associated with the instance.

    Args:
        instance_id(str): The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
        next_token(str, optional): The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return per page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.connect.approved_origin.list_all(ctx, instance_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.connect.approved_origin.list_all instance_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="connect",
        operation="list_approved_origins",
        op_kwargs={
            "InstanceId": instance_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
