"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(hub, ctx, query_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the stored query for a single AWS account and a single AWS Region.

    Args:
        query_name(str): The name of the query that you want to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.stored_query.delete(ctx, query_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.stored_query.delete query_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="delete_stored_query",
        op_kwargs={"QueryName": query_name},
    )


async def get(hub, ctx, query_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the details of a specific stored query.

    Args:
        query_name(str): The name of the query.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.stored_query.get(ctx, query_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.stored_query.get query_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="get_stored_query",
        op_kwargs={"QueryName": query_name},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the stored queries for a single AWS account and a single AWS Region. The default is 100.

    Args:
        next_token(str, optional): The nextToken string returned in a previous request that you use to request the next page of results in a paginated response. Defaults to None.
        max_results(int, optional): The maximum number of results to be returned with a single call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.stored_query.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.stored_query.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="list_stored_queries",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )


async def put(hub, ctx, stored_query: Dict, tags: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Saves a new query or updates an existing saved query. The QueryName must be unique for a single AWS account and a single AWS Region. You can create upto 300 queries in a single AWS account and a single AWS Region.

    Args:
        stored_query(Dict): A list of StoredQuery objects. The mandatory fields are QueryName and Expression.  When you are creating a query, you must provide a query name and an expression. When you are updating a query, you must provide a query name but updating the description is optional. .
        tags(List, optional): A list of Tags object. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.stored_query.put(ctx, stored_query=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.stored_query.put stored_query=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="put_stored_query",
        op_kwargs={"StoredQuery": stored_query, "Tags": tags},
    )
