"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(hub, ctx, retention_configuration_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the retention configuration.

    Args:
        retention_configuration_name(str): The name of the retention configuration to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.retention_configuration.delete(
                ctx, retention_configuration_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.retention_configuration.delete retention_configuration_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="delete_retention_configuration",
        op_kwargs={"RetentionConfigurationName": retention_configuration_name},
    )


async def describe_all(
    hub, ctx, retention_configuration_names: List = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the details of one or more retention configurations. If the retention configuration name is not specified, this action returns the details for all the retention configurations for that account.  Currently, AWS Config supports only one retention configuration per region in your account.

    Args:
        retention_configuration_names(List, optional): A list of names of retention configurations for which you want details. If you do not specify a name, AWS Config returns details for all the retention configurations for that account.  Currently, AWS Config supports only one retention configuration per region in your account. . Defaults to None.
        next_token(str, optional): The nextToken string returned on a previous page that you use to get the next page of results in a paginated response. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.retention_configuration.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.retention_configuration.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="describe_retention_configurations",
        op_kwargs={
            "RetentionConfigurationNames": retention_configuration_names,
            "NextToken": next_token,
        },
    )


async def put(hub, ctx, retention_period_in_days: int) -> Dict:
    r"""
    **Autogenerated function**

    Creates and updates the retention configuration with details about retention period (number of days) that AWS Config stores your historical information. The API creates the RetentionConfiguration object and names the object as default. When you have a RetentionConfiguration object named default, calling the API modifies the default object.   Currently, AWS Config supports only one retention configuration per region in your account.

    Args:
        retention_period_in_days(int): Number of days AWS Config stores your historical information.  Currently, only applicable to the configuration item history. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.retention_configuration.put(
                ctx, retention_period_in_days=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.retention_configuration.put retention_period_in_days=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="put_retention_configuration",
        op_kwargs={"RetentionPeriodInDays": retention_period_in_days},
    )
