"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, resource_type: str, resource_id: str) -> None:
    r"""
    **Autogenerated function**

    Records the configuration state for a custom resource that has been deleted. This API records a new ConfigurationItem with a ResourceDeleted status. You can retrieve the ConfigurationItems recorded for this resource in your AWS Config History.

    Args:
        resource_type(str): The type of the resource.
        resource_id(str): Unique identifier of the resource.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.resource.config.init.delete(
                ctx, resource_type=value, resource_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.resource.config.init.delete resource_type=value, resource_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="delete_resource_config",
        op_kwargs={"ResourceType": resource_type, "ResourceId": resource_id},
    )


async def put(
    hub,
    ctx,
    resource_type: str,
    schema_version_id: str,
    resource_id: str,
    configuration: str,
    resource_name: str = None,
    tags: Dict = None,
) -> None:
    r"""
    **Autogenerated function**

    Records the configuration state for the resource provided in the request. The configuration state of a resource is represented in AWS Config as Configuration Items. Once this API records the configuration item, you can retrieve the list of configuration items for the custom resource type using existing AWS Config APIs.   The custom resource type must be registered with AWS CloudFormation. This API accepts the configuration item registered with AWS CloudFormation. When you call this API, AWS Config only stores configuration state of the resource provided in the request. This API does not change or remediate the configuration of the resource.  Write-only schema properites are not recorded as part of the published configuration item.

    Args:
        resource_type(str): The type of the resource. The custom resource type must be registered with AWS CloudFormation.   You cannot use the organization names “aws”, “amzn”, “amazon”, “alexa”, “custom” with custom resource types. It is the first part of the ResourceType up to the first ::. .
        schema_version_id(str): Version of the schema registered for the ResourceType in AWS CloudFormation.
        resource_id(str): Unique identifier of the resource.
        resource_name(str, optional): Name of the resource. Defaults to None.
        configuration(str): The configuration object of the resource in valid JSON format. It must match the schema registered with AWS CloudFormation.  The configuration JSON must not exceed 64 KB. .
        tags(Dict, optional): Tags associated with the resource. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.resource.config.init.put(
                ctx,
                resource_type=value,
                schema_version_id=value,
                resource_id=value,
                configuration=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.resource.config.init.put resource_type=value, schema_version_id=value, resource_id=value, configuration=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="put_resource_config",
        op_kwargs={
            "ResourceType": resource_type,
            "SchemaVersionId": schema_version_id,
            "ResourceId": resource_id,
            "ResourceName": resource_name,
            "Configuration": configuration,
            "Tags": tags,
        },
    )


async def select(
    hub, ctx, expression: str, limit: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Accepts a structured query language (SQL) SELECT command, performs the corresponding search, and returns resource configurations matching the properties. For more information about query components, see the  Query Components  section in the AWS Config Developer Guide.

    Args:
        expression(str): The SQL query SELECT command.
        limit(int, optional): The maximum number of query results returned on each page. . Defaults to None.
        next_token(str, optional): The nextToken string returned in a previous request that you use to request the next page of results in a paginated response. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.resource.config.init.select(ctx, expression=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.resource.config.init.select expression=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="select_resource_config",
        op_kwargs={"Expression": expression, "Limit": limit, "NextToken": next_token},
    )
