"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    resource_type: str,
    resource_id: str,
    later_time: str = None,
    earlier_time: str = None,
    chronological_order: str = None,
    limit: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of configuration items for the specified resource. The list contains details about each state of the resource during the specified time interval. If you specified a retention period to retain your ConfigurationItems between a minimum of 30 days and a maximum of 7 years (2557 days), AWS Config returns the ConfigurationItems for the specified retention period.  The response is paginated. By default, AWS Config returns a limit of 10 configuration items per page. You can customize this number with the limit parameter. The response includes a nextToken string. To get the next page of results, run the request again and specify the string for the nextToken parameter.  Each call to the API is limited to span a duration of seven days. It is likely that the number of records returned is smaller than the specified limit. In such cases, you can make another call, using the nextToken.

    Args:
        resource_type(str): The resource type.
        resource_id(str): The ID of the resource (for example., sg-xxxxxx).
        later_time(str, optional): The time stamp that indicates a later time. If not specified, current time is taken. Defaults to None.
        earlier_time(str, optional): The time stamp that indicates an earlier time. If not specified, the action returns paginated results that contain configuration items that start when the first configuration item was recorded. Defaults to None.
        chronological_order(str, optional): The chronological order for configuration items listed. By default, the results are listed in reverse chronological order. Defaults to None.
        limit(int, optional): The maximum number of configuration items returned on each page. The default is 10. You cannot specify a number greater than 100. If you specify 0, AWS Config uses the default. Defaults to None.
        next_token(str, optional): The nextToken string returned on a previous page that you use to get the next page of results in a paginated response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.resource.config.history.get(
                ctx, resource_type=value, resource_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.resource.config.history.get resource_type=value, resource_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="get_resource_config_history",
        op_kwargs={
            "resourceType": resource_type,
            "resourceId": resource_id,
            "laterTime": later_time,
            "earlierTime": earlier_time,
            "chronologicalOrder": chronological_order,
            "limit": limit,
            "nextToken": next_token,
        },
    )
