"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def start(hub, ctx, config_rule_name: str, resource_keys: List) -> Dict:
    r"""
    **Autogenerated function**

    Runs an on-demand remediation for the specified AWS Config rules against the last known remediation configuration. It runs an execution against the current state of your resources. Remediation execution is asynchronous. You can specify up to 100 resource keys per request. An existing StartRemediationExecution call for the specified resource keys must complete before you can call the API again.

    Args:
        config_rule_name(str): The list of names of AWS Config rules that you want to run remediation execution for.
        resource_keys(List): A list of resource keys to be processed with the current request. Each element in the list consists of the resource type and resource ID. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.remediation.execution.init.start(
                ctx, config_rule_name=value, resource_keys=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.remediation.execution.init.start config_rule_name=value, resource_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="start_remediation_execution",
        op_kwargs={"ConfigRuleName": config_rule_name, "ResourceKeys": resource_keys},
    )
