"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete_multiple(hub, ctx, config_rule_name: str, resource_keys: List) -> Dict:
    r"""
    **Autogenerated function**

    Deletes one or more remediation exceptions mentioned in the resource keys.  AWS Config generates a remediation exception when a problem occurs executing a remediation action to a specific resource. Remediation exceptions blocks auto-remediation until the exception is cleared.

    Args:
        config_rule_name(str): The name of the AWS Config rule for which you want to delete remediation exception configuration.
        resource_keys(List): An exception list of resource exception keys to be processed with the current request. AWS Config adds exception for each resource key. For example, AWS Config adds 3 exceptions for 3 resource keys. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.remediation.exception.delete_multiple(
                ctx, config_rule_name=value, resource_keys=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.remediation.exception.delete_multiple config_rule_name=value, resource_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="delete_remediation_exceptions",
        op_kwargs={"ConfigRuleName": config_rule_name, "ResourceKeys": resource_keys},
    )


async def describe_all(
    hub,
    ctx,
    config_rule_name: str,
    resource_keys: List = None,
    limit: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the details of one or more remediation exceptions. A detailed view of a remediation exception for a set of resources that includes an explanation of an exception and the time when the exception will be deleted. When you specify the limit and the next token, you receive a paginated response.   AWS Config generates a remediation exception when a problem occurs executing a remediation action to a specific resource. Remediation exceptions blocks auto-remediation until the exception is cleared. When you specify the limit and the next token, you receive a paginated response.  Limit and next token are not applicable if you request resources in batch. It is only applicable, when you request all resources.

    Args:
        config_rule_name(str): The name of the AWS Config rule.
        resource_keys(List, optional): An exception list of resource exception keys to be processed with the current request. AWS Config adds exception for each resource key. For example, AWS Config adds 3 exceptions for 3 resource keys. . Defaults to None.
        limit(int, optional): The maximum number of RemediationExceptionResourceKey returned on each page. The default is 25. If you specify 0, AWS Config uses the default. Defaults to None.
        next_token(str, optional): The nextToken string returned in a previous request that you use to request the next page of results in a paginated response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.remediation.exception.describe_all(
                ctx, config_rule_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.remediation.exception.describe_all config_rule_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="describe_remediation_exceptions",
        op_kwargs={
            "ConfigRuleName": config_rule_name,
            "ResourceKeys": resource_keys,
            "Limit": limit,
            "NextToken": next_token,
        },
    )


async def put_multiple(
    hub,
    ctx,
    config_rule_name: str,
    resource_keys: List,
    message: str = None,
    expiration_time: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    A remediation exception is when a specific resource is no longer considered for auto-remediation. This API adds a new exception or updates an existing exception for a specific resource with a specific AWS Config rule.   AWS Config generates a remediation exception when a problem occurs executing a remediation action to a specific resource. Remediation exceptions blocks auto-remediation until the exception is cleared.

    Args:
        config_rule_name(str): The name of the AWS Config rule for which you want to create remediation exception.
        resource_keys(List): An exception list of resource exception keys to be processed with the current request. AWS Config adds exception for each resource key. For example, AWS Config adds 3 exceptions for 3 resource keys. .
        message(str, optional): The message contains an explanation of the exception. Defaults to None.
        expiration_time(str, optional): The exception is automatically deleted after the expiration date. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.remediation.exception.put_multiple(
                ctx, config_rule_name=value, resource_keys=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.remediation.exception.put_multiple config_rule_name=value, resource_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="put_remediation_exceptions",
        op_kwargs={
            "ConfigRuleName": config_rule_name,
            "ResourceKeys": resource_keys,
            "Message": message,
            "ExpirationTime": expiration_time,
        },
    )
