"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(hub, ctx, config_rule_name: str, resource_type: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the remediation configuration.

    Args:
        config_rule_name(str): The name of the AWS Config rule for which you want to delete remediation configuration.
        resource_type(str, optional): The type of a resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.remediation.configuration.delete(
                ctx, config_rule_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.remediation.configuration.delete config_rule_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="delete_remediation_configuration",
        op_kwargs={"ConfigRuleName": config_rule_name, "ResourceType": resource_type},
    )


async def describe_all(hub, ctx, config_rule_names: List) -> Dict:
    r"""
    **Autogenerated function**

    Returns the details of one or more remediation configurations.

    Args:
        config_rule_names(List): A list of AWS Config rule names of remediation configurations for which you want details. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.remediation.configuration.describe_all(
                ctx, config_rule_names=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.remediation.configuration.describe_all config_rule_names=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="describe_remediation_configurations",
        op_kwargs={"ConfigRuleNames": config_rule_names},
    )


async def put_multiple(hub, ctx, remediation_configurations: List) -> Dict:
    r"""
    **Autogenerated function**

    Adds or updates the remediation configuration with a specific AWS Config rule with the selected target or action. The API creates the RemediationConfiguration object for the AWS Config rule. The AWS Config rule must already exist for you to add a remediation configuration. The target (SSM document) must exist and have permissions to use the target.   If you make backward incompatible changes to the SSM document, you must call this again to ensure the remediations can run. This API does not support adding remediation configurations for service-linked AWS Config Rules such as Organization Config rules, the rules deployed by conformance packs, and rules deployed by AWS Security Hub.

    Args:
        remediation_configurations(List): A list of remediation configuration objects.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.remediation.configuration.put_multiple(
                ctx, remediation_configurations=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.remediation.configuration.put_multiple remediation_configurations=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="put_remediation_configurations",
        op_kwargs={"RemediationConfigurations": remediation_configurations},
    )
