"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(hub, ctx, organization_conformance_pack_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified organization conformance pack and all of the config rules and remediation actions from all member accounts in that organization.   Only a master account or a delegated administrator account can delete an organization conformance pack. When calling this API with a delegated administrator, you must ensure AWS Organizations ListDelegatedAdministrator permissions are added. AWS Config sets the state of a conformance pack to DELETE_IN_PROGRESS until the deletion is complete. You cannot update a conformance pack while it is in this state.

    Args:
        organization_conformance_pack_name(str): The name of organization conformance pack that you want to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.organization.conformance_pack.init.delete(
                ctx, organization_conformance_pack_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.organization.conformance_pack.init.delete organization_conformance_pack_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="delete_organization_conformance_pack",
        op_kwargs={
            "OrganizationConformancePackName": organization_conformance_pack_name
        },
    )


async def describe_all(
    hub,
    ctx,
    organization_conformance_pack_names: List = None,
    limit: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of organization conformance packs.   When you specify the limit and the next token, you receive a paginated response.  Limit and next token are not applicable if you specify organization conformance packs names. They are only applicable, when you request all the organization conformance packs.

    Args:
        organization_conformance_pack_names(List, optional): The name that you assign to an organization conformance pack. Defaults to None.
        limit(int, optional): The maximum number of organization config packs returned on each page. If you do no specify a number, AWS Config uses the default. The default is 100. Defaults to None.
        next_token(str, optional): The nextToken string returned on a previous page that you use to get the next page of results in a paginated response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.organization.conformance_pack.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.organization.conformance_pack.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="describe_organization_conformance_packs",
        op_kwargs={
            "OrganizationConformancePackNames": organization_conformance_pack_names,
            "Limit": limit,
            "NextToken": next_token,
        },
    )


async def put(
    hub,
    ctx,
    organization_conformance_pack_name: str,
    template_s3_uri: str = None,
    template_body: str = None,
    delivery_s3_bucket: str = None,
    delivery_s3_key_prefix: str = None,
    conformance_pack_input_parameters: List = None,
    excluded_accounts: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Deploys conformance packs across member accounts in an AWS Organization. Only a master account and a delegated administrator can call this API. When calling this API with a delegated administrator, you must ensure AWS Organizations ListDelegatedAdministrator permissions are added. This API enables organization service access for config-multiaccountsetup.amazonaws.com through the EnableAWSServiceAccess action and creates a service linked role AWSServiceRoleForConfigMultiAccountSetup in the master or delegated administrator account of your organization. The service linked role is created only when the role does not exist in the caller account. To use this API with delegated administrator, register a delegated administrator by calling AWS Organization register-delegate-admin for config-multiaccountsetup.amazonaws.com.  Prerequisite: Ensure you call EnableAllFeatures API to enable all features in an organization. You must specify either the TemplateS3Uri or the TemplateBody parameter, but not both. If you provide both AWS Config uses the TemplateS3Uri parameter and ignores the TemplateBody parameter. AWS Config sets the state of a conformance pack to CREATE_IN_PROGRESS and UPDATE_IN_PROGRESS until the conformance pack is created or updated. You cannot update a conformance pack while it is in this state. You can create 50 conformance packs with 25 AWS Config rules in each pack and 3 delegated administrator per organization.

    Args:
        organization_conformance_pack_name(str): Name of the organization conformance pack you want to create.
        template_s3_uri(str, optional): Location of file containing the template body. The uri must point to the conformance pack template (max size: 300 KB).  You must have access to read Amazon S3 bucket. . Defaults to None.
        template_body(str, optional): A string containing full conformance pack template body. Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes. Defaults to None.
        delivery_s3_bucket(str, optional): Amazon S3 bucket where AWS Config stores conformance pack templates.  This field is optional. If used, it must be prefixed with awsconfigconforms. . Defaults to None.
        delivery_s3_key_prefix(str, optional): The prefix for the Amazon S3 bucket.  This field is optional. . Defaults to None.
        conformance_pack_input_parameters(List, optional): A list of ConformancePackInputParameter objects. Defaults to None.
        excluded_accounts(List, optional): A list of AWS accounts to be excluded from an organization conformance pack while deploying a conformance pack. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.organization.conformance_pack.init.put(
                ctx, organization_conformance_pack_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.organization.conformance_pack.init.put organization_conformance_pack_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="put_organization_conformance_pack",
        op_kwargs={
            "OrganizationConformancePackName": organization_conformance_pack_name,
            "TemplateS3Uri": template_s3_uri,
            "TemplateBody": template_body,
            "DeliveryS3Bucket": delivery_s3_bucket,
            "DeliveryS3KeyPrefix": delivery_s3_key_prefix,
            "ConformancePackInputParameters": conformance_pack_input_parameters,
            "ExcludedAccounts": excluded_accounts,
        },
    )
