"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    organization_conformance_pack_name: str,
    filters: Dict = None,
    limit: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns detailed status for each member account within an organization for a given organization conformance pack.

    Args:
        organization_conformance_pack_name(str): The name of organization conformance pack for which you want status details for member accounts.
        filters(Dict, optional): An OrganizationResourceDetailedStatusFilters object. Defaults to None.
        limit(int, optional): The maximum number of OrganizationConformancePackDetailedStatuses returned on each page. If you do not specify a number, AWS Config uses the default. The default is 100. . Defaults to None.
        next_token(str, optional): The nextToken string returned on a previous page that you use to get the next page of results in a paginated response. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.organization.conformance_pack.detailed_status.get(
                ctx, organization_conformance_pack_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.organization.conformance_pack.detailed_status.get organization_conformance_pack_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="get_organization_conformance_pack_detailed_status",
        op_kwargs={
            "OrganizationConformancePackName": organization_conformance_pack_name,
            "Filters": filters,
            "Limit": limit,
            "NextToken": next_token,
        },
    )
