"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(hub, ctx, organization_config_rule_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified organization config rule and all of its evaluation results from all member accounts in that organization.  Only a master account and a delegated administrator account can delete an organization config rule. When calling this API with a delegated administrator, you must ensure AWS Organizations ListDelegatedAdministrator permissions are added. AWS Config sets the state of a rule to DELETE_IN_PROGRESS until the deletion is complete. You cannot update a rule while it is in this state.

    Args:
        organization_config_rule_name(str): The name of organization config rule that you want to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.organization.config_rule.init.delete(
                ctx, organization_config_rule_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.organization.config_rule.init.delete organization_config_rule_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="delete_organization_config_rule",
        op_kwargs={"OrganizationConfigRuleName": organization_config_rule_name},
    )


async def describe_all(
    hub,
    ctx,
    organization_config_rule_names: List = None,
    limit: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of organization config rules.   When you specify the limit and the next token, you receive a paginated response. Limit and next token are not applicable if you specify organization config rule names. It is only applicable, when you request all the organization config rules.

    Args:
        organization_config_rule_names(List, optional): The names of organization config rules for which you want details. If you do not specify any names, AWS Config returns details for all your organization config rules. Defaults to None.
        limit(int, optional): The maximum number of organization config rules returned on each page. If you do no specify a number, AWS Config uses the default. The default is 100. Defaults to None.
        next_token(str, optional): The nextToken string returned on a previous page that you use to get the next page of results in a paginated response. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.organization.config_rule.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.organization.config_rule.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="describe_organization_config_rules",
        op_kwargs={
            "OrganizationConfigRuleNames": organization_config_rule_names,
            "Limit": limit,
            "NextToken": next_token,
        },
    )


async def put(
    hub,
    ctx,
    organization_config_rule_name: str,
    organization_managed_rule_metadata: Dict = None,
    organization_custom_rule_metadata: Dict = None,
    excluded_accounts: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Adds or updates organization config rule for your entire organization evaluating whether your AWS resources comply with your desired configurations.  Only a master account and a delegated administrator can create or update an organization config rule. When calling this API with a delegated administrator, you must ensure AWS Organizations ListDelegatedAdministrator permissions are added.  This API enables organization service access through the EnableAWSServiceAccess action and creates a service linked role AWSServiceRoleForConfigMultiAccountSetup in the master or delegated administrator account of your organization. The service linked role is created only when the role does not exist in the caller account. AWS Config verifies the existence of role with GetRole action. To use this API with delegated administrator, register a delegated administrator by calling AWS Organization register-delegated-administrator for config-multiaccountsetup.amazonaws.com.  You can use this action to create both custom AWS Config rules and AWS managed Config rules. If you are adding a new custom AWS Config rule, you must first create AWS Lambda function in the master account or a delegated administrator that the rule invokes to evaluate your resources. When you use the PutOrganizationConfigRule action to add the rule to AWS Config, you must specify the Amazon Resource Name (ARN) that AWS Lambda assigns to the function. If you are adding an AWS managed Config rule, specify the rule's identifier for the RuleIdentifier key. The maximum number of organization config rules that AWS Config supports is 150 and 3 delegated administrator per organization.   Prerequisite: Ensure you call EnableAllFeatures API to enable all features in an organization. Specify either OrganizationCustomRuleMetadata or OrganizationManagedRuleMetadata.

    Args:
        organization_config_rule_name(str): The name that you assign to an organization config rule.
        organization_managed_rule_metadata(Dict, optional): An OrganizationManagedRuleMetadata object. . Defaults to None.
        organization_custom_rule_metadata(Dict, optional): An OrganizationCustomRuleMetadata object. Defaults to None.
        excluded_accounts(List, optional): A comma-separated list of accounts that you want to exclude from an organization config rule. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.organization.config_rule.init.put(
                ctx, organization_config_rule_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.organization.config_rule.init.put organization_config_rule_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="put_organization_config_rule",
        op_kwargs={
            "OrganizationConfigRuleName": organization_config_rule_name,
            "OrganizationManagedRuleMetadata": organization_managed_rule_metadata,
            "OrganizationCustomRuleMetadata": organization_custom_rule_metadata,
            "ExcludedAccounts": excluded_accounts,
        },
    )
