"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, resource_keys: List) -> Dict:
    r"""
    **Autogenerated function**

    Returns the current configuration for one or more requested resources. The operation also returns a list of resources that are not processed in the current request. If there are no unprocessed resources, the operation returns an empty unprocessedResourceKeys list.     The API does not return results for deleted resources.    The API does not return any tags for the requested resources. This information is filtered out of the supplementaryConfiguration section of the API response.

    Args:
        resource_keys(List): A list of resource keys to be processed with the current request. Each element in the list consists of the resource type and resource ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.get.resource_config.batch(ctx, resource_keys=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.get.resource_config.batch resource_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="batch_get_resource_config",
        op_kwargs={"resourceKeys": resource_keys},
    )
