"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(
    hub, ctx, configuration_aggregator_name: str, resource_identifiers: List
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the current configuration items for resources that are present in your AWS Config aggregator. The operation also returns a list of resources that are not processed in the current request. If there are no unprocessed resources, the operation returns an empty unprocessedResourceIdentifiers list.     The API does not return results for deleted resources.    The API does not return tags and relationships.

    Args:
        configuration_aggregator_name(str): The name of the configuration aggregator.
        resource_identifiers(List): A list of aggregate ResourceIdentifiers objects. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.get.aggregate_resource_config.batch(
                ctx, configuration_aggregator_name=value, resource_identifiers=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.get.aggregate_resource_config.batch configuration_aggregator_name=value, resource_identifiers=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="batch_get_aggregate_resource_config",
        op_kwargs={
            "ConfigurationAggregatorName": configuration_aggregator_name,
            "ResourceIdentifiers": resource_identifiers,
        },
    )
