"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def put(hub, ctx, config_rule_name: str, external_evaluation: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Add or updates the evaluations for process checks. This API checks if the rule is a process check when the name of the AWS Config rule is provided.

    Args:
        config_rule_name(str): The name of the AWS Config rule.
        external_evaluation(Dict): An ExternalEvaluation object that provides details about compliance.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.external_evaluation.put(
                ctx, config_rule_name=value, external_evaluation=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.external_evaluation.put config_rule_name=value, external_evaluation=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="put_external_evaluation",
        op_kwargs={
            "ConfigRuleName": config_rule_name,
            "ExternalEvaluation": external_evaluation,
        },
    )
