"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete_multiple(hub, ctx, config_rule_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the evaluation results for the specified AWS Config rule. You can specify one AWS Config rule per request. After you delete the evaluation results, you can call the StartConfigRulesEvaluation API to start evaluating your AWS resources against the rule.

    Args:
        config_rule_name(str): The name of the AWS Config rule for which you want to delete the evaluation results.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.evaluation.result.delete_multiple(
                ctx, config_rule_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.evaluation.result.delete_multiple config_rule_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="delete_evaluation_results",
        op_kwargs={"ConfigRuleName": config_rule_name},
    )
