"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def put_multiple(
    hub, ctx, result_token: str, evaluations: List = None, test_mode: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Used by an AWS Lambda function to deliver evaluation results to AWS Config. This action is required in every AWS Lambda function that is invoked by an AWS Config rule.

    Args:
        evaluations(List, optional): The assessments that the AWS Lambda function performs. Each evaluation identifies an AWS resource and indicates whether it complies with the AWS Config rule that invokes the AWS Lambda function. Defaults to None.
        result_token(str): An encrypted token that associates an evaluation with an AWS Config rule. Identifies the rule and the event that triggered the evaluation.
        test_mode(bool, optional): Use this parameter to specify a test run for PutEvaluations. You can verify whether your AWS Lambda function will deliver evaluation results to AWS Config. No updates occur to your existing evaluations, and evaluation results are not sent to AWS Config.  When TestMode is true, PutEvaluations doesn't require a valid value for the ResultToken parameter, but the value cannot be null. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.evaluation.init.put_multiple(ctx, result_token=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.evaluation.init.put_multiple result_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="put_evaluations",
        op_kwargs={
            "Evaluations": evaluations,
            "ResultToken": result_token,
            "TestMode": test_mode,
        },
    )
