"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def list_all(
    hub,
    ctx,
    resource_type: str,
    resource_ids: List = None,
    resource_name: str = None,
    limit: int = None,
    include_deleted_resources: bool = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Accepts a resource type and returns a list of resource identifiers for the resources of that type. A resource identifier includes the resource type, ID, and (if available) the custom resource name. The results consist of resources that AWS Config has discovered, including those that AWS Config is not currently recording. You can narrow the results to include only resources that have specific resource IDs or a resource name.  You can specify either resource IDs or a resource name, but not both, in the same request.  The response is paginated. By default, AWS Config lists 100 resource identifiers on each page. You can customize this number with the limit parameter. The response includes a nextToken string. To get the next page of results, run the request again and specify the string for the nextToken parameter.

    Args:
        resource_type(str): The type of resources that you want AWS Config to list in the response.
        resource_ids(List, optional): The IDs of only those resources that you want AWS Config to list in the response. If you do not specify this parameter, AWS Config lists all resources of the specified type that it has discovered. Defaults to None.
        resource_name(str, optional): The custom name of only those resources that you want AWS Config to list in the response. If you do not specify this parameter, AWS Config lists all resources of the specified type that it has discovered. Defaults to None.
        limit(int, optional): The maximum number of resource identifiers returned on each page. The default is 100. You cannot specify a number greater than 100. If you specify 0, AWS Config uses the default. Defaults to None.
        include_deleted_resources(bool, optional): Specifies whether AWS Config includes deleted resources in the results. By default, deleted resources are not included. Defaults to None.
        next_token(str, optional): The nextToken string returned on a previous page that you use to get the next page of results in a paginated response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.discovered_resource.init.list_all(
                ctx, resource_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.discovered_resource.init.list_all resource_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="list_discovered_resources",
        op_kwargs={
            "resourceType": resource_type,
            "resourceIds": resource_ids,
            "resourceName": resource_name,
            "limit": limit,
            "includeDeletedResources": include_deleted_resources,
            "nextToken": next_token,
        },
    )
