"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe(hub, ctx, delivery_channel_names: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns the current status of the specified delivery channel. If a delivery channel is not specified, this action returns the current status of all delivery channels associated with the account.  Currently, you can specify only one delivery channel per region in your account.

    Args:
        delivery_channel_names(List, optional): A list of delivery channel names. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.delivery_channel.status.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.delivery_channel.status.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="describe_delivery_channel_status",
        op_kwargs={"DeliveryChannelNames": delivery_channel_names},
    )
