"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(hub, ctx, delivery_channel_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the delivery channel. Before you can delete the delivery channel, you must stop the configuration recorder by using the StopConfigurationRecorder action.

    Args:
        delivery_channel_name(str): The name of the delivery channel to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.delivery_channel.init.delete(
                ctx, delivery_channel_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.delivery_channel.init.delete delivery_channel_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="delete_delivery_channel",
        op_kwargs={"DeliveryChannelName": delivery_channel_name},
    )


async def describe_all(hub, ctx, delivery_channel_names: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns details about the specified delivery channel. If a delivery channel is not specified, this action returns the details of all delivery channels associated with the account.  Currently, you can specify only one delivery channel per region in your account.

    Args:
        delivery_channel_names(List, optional): A list of delivery channel names. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.delivery_channel.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.delivery_channel.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="describe_delivery_channels",
        op_kwargs={"DeliveryChannelNames": delivery_channel_names},
    )


async def put(hub, ctx, delivery_channel: Dict) -> None:
    r"""
    **Autogenerated function**

    Creates a delivery channel object to deliver configuration information to an Amazon S3 bucket and Amazon SNS topic. Before you can create a delivery channel, you must create a configuration recorder. You can use this action to change the Amazon S3 bucket or an Amazon SNS topic of the existing delivery channel. To change the Amazon S3 bucket or an Amazon SNS topic, call this action and specify the changed values for the S3 bucket and the SNS topic. If you specify a different value for either the S3 bucket or the SNS topic, this action will keep the existing value for the parameter that is not changed.  You can have only one delivery channel per region in your account.

    Args:
        delivery_channel(Dict): The configuration delivery channel object that delivers the configuration information to an Amazon S3 bucket and to an Amazon SNS topic.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.delivery_channel.init.put(ctx, delivery_channel=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.delivery_channel.init.put delivery_channel=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="put_delivery_channel",
        op_kwargs={"DeliveryChannel": delivery_channel},
    )
