"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe(
    hub,
    ctx,
    conformance_pack_names: List = None,
    limit: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Provides one or more conformance packs deployment status.  If there are no conformance packs then you will see an empty result.

    Args:
        conformance_pack_names(List, optional): Comma-separated list of conformance pack names. Defaults to None.
        limit(int, optional): The maximum number of conformance packs status returned on each page. Defaults to None.
        next_token(str, optional): The nextToken string returned in a previous request that you use to request the next page of results in a paginated response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.conformance_pack.status.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.conformance_pack.status.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="describe_conformance_pack_status",
        op_kwargs={
            "ConformancePackNames": conformance_pack_names,
            "Limit": limit,
            "NextToken": next_token,
        },
    )
