"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(hub, ctx, conformance_pack_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified conformance pack and all the AWS Config rules, remediation actions, and all evaluation results within that conformance pack. AWS Config sets the conformance pack to DELETE_IN_PROGRESS until the deletion is complete. You cannot update a conformance pack while it is in this state.

    Args:
        conformance_pack_name(str): Name of the conformance pack you want to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.conformance_pack.init.delete(
                ctx, conformance_pack_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.conformance_pack.init.delete conformance_pack_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="delete_conformance_pack",
        op_kwargs={"ConformancePackName": conformance_pack_name},
    )


async def describe_all(
    hub,
    ctx,
    conformance_pack_names: List = None,
    limit: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of one or more conformance packs.

    Args:
        conformance_pack_names(List, optional): Comma-separated list of conformance pack names for which you want details. If you do not specify any names, AWS Config returns details for all your conformance packs. . Defaults to None.
        limit(int, optional): The maximum number of conformance packs returned on each page. Defaults to None.
        next_token(str, optional): The nextToken string returned in a previous request that you use to request the next page of results in a paginated response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.conformance_pack.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.conformance_pack.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="describe_conformance_packs",
        op_kwargs={
            "ConformancePackNames": conformance_pack_names,
            "Limit": limit,
            "NextToken": next_token,
        },
    )


async def put(
    hub,
    ctx,
    conformance_pack_name: str,
    template_s3_uri: str = None,
    template_body: str = None,
    delivery_s3_bucket: str = None,
    delivery_s3_key_prefix: str = None,
    conformance_pack_input_parameters: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates or updates a conformance pack. A conformance pack is a collection of AWS Config rules that can be easily deployed in an account and a region and across AWS Organization. This API creates a service linked role AWSServiceRoleForConfigConforms in your account. The service linked role is created only when the role does not exist in your account.   You must specify either the TemplateS3Uri or the TemplateBody parameter, but not both. If you provide both AWS Config uses the TemplateS3Uri parameter and ignores the TemplateBody parameter.

    Args:
        conformance_pack_name(str): Name of the conformance pack you want to create.
        template_s3_uri(str, optional): Location of file containing the template body (s3://bucketname/prefix). The uri must point to the conformance pack template (max size: 300 KB) that is located in an Amazon S3 bucket in the same region as the conformance pack.   You must have access to read Amazon S3 bucket. . Defaults to None.
        template_body(str, optional): A string containing full conformance pack template body. Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes.  You can only use a YAML template with one resource type, that is, config rule and a remediation action.  . Defaults to None.
        delivery_s3_bucket(str, optional): Amazon S3 bucket where AWS Config stores conformance pack templates.  This field is optional. . Defaults to None.
        delivery_s3_key_prefix(str, optional): The prefix for the Amazon S3 bucket.   This field is optional. . Defaults to None.
        conformance_pack_input_parameters(List, optional): A list of ConformancePackInputParameter objects. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.conformance_pack.init.put(
                ctx, conformance_pack_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.conformance_pack.init.put conformance_pack_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="put_conformance_pack",
        op_kwargs={
            "ConformancePackName": conformance_pack_name,
            "TemplateS3Uri": template_s3_uri,
            "TemplateBody": template_body,
            "DeliveryS3Bucket": delivery_s3_bucket,
            "DeliveryS3KeyPrefix": delivery_s3_key_prefix,
            "ConformancePackInputParameters": conformance_pack_input_parameters,
        },
    )
