"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get(
    hub, ctx, conformance_pack_names: List, limit: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns compliance details for the conformance pack based on the cumulative compliance results of all the rules in that conformance pack.

    Args:
        conformance_pack_names(List): Names of conformance packs.
        limit(int, optional): The maximum number of conformance packs returned on each page. Defaults to None.
        next_token(str, optional): The nextToken string returned on a previous page that you use to get the next page of results in a paginated response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.conformance_pack.compliance.summary.get(
                ctx, conformance_pack_names=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.conformance_pack.compliance.summary.get conformance_pack_names=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="get_conformance_pack_compliance_summary",
        op_kwargs={
            "ConformancePackNames": conformance_pack_names,
            "Limit": limit,
            "NextToken": next_token,
        },
    )
