"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(
    hub,
    ctx,
    conformance_pack_name: str,
    filters: Dict = None,
    limit: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns compliance details for each rule in that conformance pack.  You must provide exact rule names.

    Args:
        conformance_pack_name(str): Name of the conformance pack.
        filters(Dict, optional): A ConformancePackComplianceFilters object. Defaults to None.
        limit(int, optional): The maximum number of AWS Config rules within a conformance pack are returned on each page. Defaults to None.
        next_token(str, optional): The nextToken string returned in a previous request that you use to request the next page of results in a paginated response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.conformance_pack.compliance.init.describe(
                ctx, conformance_pack_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.conformance_pack.compliance.init.describe conformance_pack_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="describe_conformance_pack_compliance",
        op_kwargs={
            "ConformancePackName": conformance_pack_name,
            "Filters": filters,
            "Limit": limit,
            "NextToken": next_token,
        },
    )
