"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(
    hub,
    ctx,
    conformance_pack_name: str,
    filters: Dict = None,
    limit: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns compliance details of a conformance pack for all AWS resources that are monitered by conformance pack.

    Args:
        conformance_pack_name(str): Name of the conformance pack.
        filters(Dict, optional): A ConformancePackEvaluationFilters object. Defaults to None.
        limit(int, optional): The maximum number of evaluation results returned on each page. If you do no specify a number, AWS Config uses the default. The default is 100. Defaults to None.
        next_token(str, optional): The nextToken string returned in a previous request that you use to request the next page of results in a paginated response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.conformance_pack.compliance.detail.get_all(
                ctx, conformance_pack_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.conformance_pack.compliance.detail.get_all conformance_pack_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="get_conformance_pack_compliance_details",
        op_kwargs={
            "ConformancePackName": conformance_pack_name,
            "Filters": filters,
            "Limit": limit,
            "NextToken": next_token,
        },
    )
