"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe(hub, ctx, configuration_recorder_names: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns the current status of the specified configuration recorder. If a configuration recorder is not specified, this action returns the status of all configuration recorders associated with the account.  Currently, you can specify only one configuration recorder per region in your account.

    Args:
        configuration_recorder_names(List, optional): The name(s) of the configuration recorder. If the name is not specified, the action returns the current status of all the configuration recorders associated with the account. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.config.configuration.recorder.status.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.config.configuration.recorder.status.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="config",
        operation="describe_configuration_recorder_status",
        op_kwargs={"ConfigurationRecorderNames": configuration_recorder_names},
    )
